/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.uploading;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.settings.UsageDataRecordingSettings;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadListener;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadParameters;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadResult;
import org.eclipse.epp.usagedata.internal.recording.uploading.Uploader;
import org.eclipse.ui.PlatformUI;

public class UploadManager {
    public static final int UPLOAD_STARTED_OK = 0;
    public static final int NO_FILES_TO_UPLOAD = 1;
    public static final int UPLOAD_IN_PROGRESS = 2;
    public static final int WORKBENCH_IS_CLOSING = 3;
    public static final int NO_UPLOADER = 4;
    public static final int UPLOAD_DISABLED = 5;
    private Object lock = new Object();
    private Uploader uploader;
    private ListenerList uploadListeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startUpload() {
        File[] usageDataUploadFiles;
        if (!this.getSettings().isEnabled()) {
            return 5;
        }
        if (PlatformUI.getWorkbench().isClosing()) {
            return 3;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.uploader != null) {
                return 2;
            }
            usageDataUploadFiles = this.findUsageDataUploadFiles();
            if (usageDataUploadFiles.length == 0) {
                return 1;
            }
            this.uploader = this.getUploader();
            if (this.uploader == null) {
                return 4;
            }
        }
        this.getSettings().setLastUploadTime();
        UploadParameters uploadParameters = new UploadParameters();
        uploadParameters.setSettings(this.getSettings());
        uploadParameters.setFiles(usageDataUploadFiles);
        this.uploader.setUploadParameters(uploadParameters);
        this.uploader.addUploadListener(new UploadListener(){

            public void uploadComplete(UploadResult result) {
                UploadManager.this.uploader = null;
                UploadManager.this.fireUploadComplete(result);
            }
        });
        this.uploader.startUpload();
        return 0;
    }

    private File[] findUsageDataUploadFiles() {
        return this.getSettings().getUsageDataUploadFiles();
    }

    private UsageDataRecordingSettings getSettings() {
        return UsageDataRecordingActivator.getDefault().getSettings();
    }

    private Uploader getUploader() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.epp.usagedata.recording.uploader");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("uploader".equals(element.getName())) {
                try {
                    Object uploader = element.createExecutableExtension("class");
                    if (uploader instanceof Uploader) {
                        return (Uploader)uploader;
                    }
                }
                catch (CoreException e) {
                    UsageDataRecordingActivator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        return null;
    }

    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add((Object)listener);
    }

    public void removeUploadListener(UploadListener listener) {
        this.uploadListeners.remove((Object)listener);
    }

    protected void fireUploadComplete(UploadResult result) {
        Object[] objectArray = this.uploadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((UploadListener)listener).uploadComplete(result);
            ++n2;
        }
    }
}

