/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.settings;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.UUID;
import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.gathering.settings.UsageDataCaptureSettings;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.filtering.PreferencesBasedFilter;
import org.eclipse.epp.usagedata.internal.recording.filtering.UsageDataEventFilter;
import org.eclipse.epp.usagedata.internal.recording.settings.UploadSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IDisposable;

public class UsageDataRecordingSettings
implements UploadSettings {
    private static final String DEFAULT_ID = "unknown";
    private static final String UPLOAD_FILE_PREFIX = "upload";
    public static final String UPLOAD_PERIOD_KEY = "org.eclipse.epp.usagedata.recording.period";
    public static final String LAST_UPLOAD_KEY = "org.eclipse.epp.usagedata.recording.last-upload";
    public static final String ASK_TO_UPLOAD_KEY = "org.eclipse.epp.usagedata.recording.ask";
    public static final String LOG_SERVER_ACTIVITY_KEY = "org.eclipse.epp.usagedata.recording.log-server";
    public static final String FILTER_ECLIPSE_BUNDLES_ONLY_KEY = "org.eclipse.epp.usagedata.recording.filter-eclipse-only";
    public static final String FILTER_PATTERNS_KEY = "org.eclipse.epp.usagedata.recording.filter-patterns";
    static final String UPLOAD_URL_KEY = "org.eclipse.epp.usagedata.recording.upload-url";
    public static final int PERIOD_REASONABLE_MINIMUM = 900000;
    static final int UPLOAD_PERIOD_DEFAULT = 432000000;
    static final String UPLOAD_URL_DEFAULT = "http://udc.eclipse.org/upload.php";
    static final boolean ASK_TO_UPLOAD_DEFAULT = true;
    private UsageDataEventFilter filter = new PreferencesBasedFilter();

    public long getPeriodBetweenUploads() {
        long period = 0L;
        if (System.getProperties().containsKey(UPLOAD_PERIOD_KEY)) {
            String value = System.getProperty(UPLOAD_PERIOD_KEY);
            try {
                period = Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                UsageDataRecordingActivator.getDefault().log(2, e, "The UsageDataUploader cannot parse the %1$s system property (\"%2$s\"", UPLOAD_PERIOD_KEY, value);
            }
        } else {
            period = this.getPreferencesStore().contains(UPLOAD_PERIOD_KEY) ? this.getPreferencesStore().getLong(UPLOAD_PERIOD_KEY) : 432000000L;
        }
        if (period < 900000L) {
            period = 900000L;
        }
        return period;
    }

    public long getLastUploadTime() {
        if (this.getPreferencesStore().contains(LAST_UPLOAD_KEY)) {
            return this.getPreferencesStore().getLong(LAST_UPLOAD_KEY);
        }
        long period = System.currentTimeMillis();
        this.getPreferencesStore().setValue(LAST_UPLOAD_KEY, period);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
        return period;
    }

    public boolean isTimeToUpload() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return false;
        }
        return System.currentTimeMillis() - this.getLastUploadTime() > this.getPeriodBetweenUploads();
    }

    public File getEventFile() {
        return new File(this.getWorkingDirectory(), "usagedata.csv");
    }

    public File computeDestinationFile() {
        int index = 0;
        File parent = this.getWorkingDirectory();
        File file = null;
        while ((file = new File(parent, UPLOAD_FILE_PREFIX + index++ + ".csv")).exists()) {
        }
        return file;
    }

    public String getUserId() {
        return this.getExistingOrGenerateId(new File(System.getProperty("user.home")), ".org.eclipse.epp.usagedata.recording.userId");
    }

    public String getWorkspaceId() {
        return this.getExistingOrGenerateId(this.getWorkingDirectory(), ".org.eclipse.epp.usagedata.recording.workspaceId");
    }

    public boolean isLoggingServerActivity() {
        return "true".equals(System.getProperty(LOG_SERVER_ACTIVITY_KEY));
    }

    public File[] getUsageDataUploadFiles() {
        return this.getWorkingDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(UsageDataRecordingSettings.UPLOAD_FILE_PREFIX);
            }
        });
    }

    public void setLastUploadTime() {
        this.getPreferencesStore().setValue(LAST_UPLOAD_KEY, System.currentTimeMillis());
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    private String getExistingOrGenerateId(File directory, String fileName) {
        if (!directory.exists()) {
            return DEFAULT_ID;
        }
        directory.isDirectory();
        File file = new File(directory, fileName);
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                char[] buffer = new char[256];
                int count = reader.read(buffer);
                String string = new String(buffer, 0, count);
                return string;
            }
            catch (IOException e) {
                this.handleCannotReadFileException(file, e);
                return DEFAULT_ID;
            }
            finally {
                this.close(reader);
            }
        }
        String id = UUID.randomUUID().toString();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(id);
            String string = id;
            return string;
        }
        catch (IOException e) {
            this.handleCannotReadFileException(file, e);
            return DEFAULT_ID;
        }
        finally {
            this.close(writer);
        }
    }

    private void handleCannotReadFileException(File file, IOException e) {
        UsageDataRecordingActivator.getDefault().log(2, e, "Cannot read the existing id from %1$s; using the default.", file.toString());
    }

    private IPreferenceStore getPreferencesStore() {
        return UsageDataRecordingActivator.getDefault().getPreferenceStore();
    }

    private File getWorkingDirectory() {
        return UsageDataRecordingActivator.getDefault().getStateLocation().toFile();
    }

    private void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {}
    }

    private void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    public boolean shouldAskBeforeUploading() {
        if (System.getProperties().containsKey(ASK_TO_UPLOAD_KEY)) {
            return "true".equals(System.getProperty(ASK_TO_UPLOAD_KEY));
        }
        if (this.getPreferencesStore().contains(ASK_TO_UPLOAD_KEY)) {
            return this.getPreferencesStore().getBoolean(ASK_TO_UPLOAD_KEY);
        }
        return true;
    }

    public UsageDataEventFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UsageDataEventFilter filter) {
        this.filter = filter;
    }

    public boolean hasUserAcceptedTermsOfUse() {
        return this.getCaptureSettings().hasUserAcceptedTermsOfUse();
    }

    public void setUserAcceptedTermsOfUse(boolean value) {
        this.getCaptureSettings().setUserAcceptedTermsOfUse(value);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    private UsageDataCaptureSettings getCaptureSettings() {
        return UsageDataCaptureActivator.getDefault().getSettings();
    }

    public boolean isEnabled() {
        return this.getCaptureSettings().isEnabled();
    }

    public void setAskBeforeUploading(boolean value) {
        this.getPreferencesStore().setValue(ASK_TO_UPLOAD_KEY, value);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    public void setEnabled(boolean value) {
        this.getCaptureSettings().setEnabled(value);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    public void dispose() {
        if (this.filter instanceof IDisposable) {
            ((IDisposable)this.filter).dispose();
        }
    }

    public String getUserAgent() {
        return "Eclipse UDC/" + (String)UsageDataRecordingActivator.getDefault().getBundle().getHeaders().get("Bundle-Version");
    }

    public String getUploadUrl() {
        if (System.getProperties().containsKey(UPLOAD_URL_KEY)) {
            return System.getProperty(UPLOAD_URL_KEY);
        }
        return UPLOAD_URL_DEFAULT;
    }
}

