/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.GroupCategory;

public class GroupCategorySet {
    public static final GroupCategorySet NONE = new GroupCategorySet(){

        public boolean contains(GroupCategory category) {
            return false;
        }

        public List asList() {
            return Collections.EMPTY_LIST;
        }
    };
    private List fContent;

    public static GroupCategorySet union(GroupCategorySet one, GroupCategorySet two) {
        Assert.isNotNull((Object)one);
        Assert.isNotNull((Object)two);
        if (one == two) {
            return one;
        }
        if (one == NONE) {
            return two;
        }
        if (two == NONE) {
            return one;
        }
        HashSet combined = new HashSet();
        combined.addAll(one.asList());
        combined.addAll(two.asList());
        return new GroupCategorySet(combined);
    }

    private GroupCategorySet() {
        this.fContent = Collections.EMPTY_LIST;
    }

    private GroupCategorySet(Set categories) {
        this.fContent = new ArrayList(categories);
    }

    public GroupCategorySet(GroupCategory category) {
        Assert.isNotNull((Object)category);
        this.fContent = new ArrayList(1);
        this.fContent.add(category);
    }

    public GroupCategorySet(GroupCategory[] categories) {
        Assert.isNotNull((Object)categories);
        this.fContent = new ArrayList(categories.length);
        int i = 0;
        while (i < categories.length) {
            if (!this.fContent.contains(categories[i])) {
                this.fContent.add(categories[i]);
            }
            ++i;
        }
    }

    public boolean contains(GroupCategory category) {
        return this.fContent.contains(category);
    }

    public boolean containsOneCategory(List categories) {
        Iterator iter = categories.iterator();
        while (iter.hasNext()) {
            GroupCategory category = (GroupCategory)iter.next();
            if (!this.contains(category)) continue;
            return true;
        }
        return false;
    }

    public List asList() {
        return Collections.unmodifiableList(this.fContent);
    }

    /* synthetic */ GroupCategorySet(GroupCategorySet groupCategorySet) {
        this();
    }
}

